#include <HT66F019.H>
//----------------------------------------------------------------------------
// Name     : bc7262.c
// Purpose  : 
// Note(s)  : 
//----------------------------------------------------------------------------

#include	"mcu.h" 
#include	"bc7262.h"
#include	"ble_adv.h"
#include	"parameter.h"

#define		_TEST_LIRC_			0

#define IIC_WRITE_DADDR   		(BC7262_DEVICE_ADDR << 1)
#define IIC_READ_DADDR    		((BC7262_DEVICE_ADDR << 1) | 0x01)

#define	SCL_SET()			(BC7262SCL=HIGH)
#define	SCL_RESET()			(BC7262SCL=LOW)
#define	SCL_DIROUT()		(BC7262SCLDIR=LOW)
#define	SDA_SET()			(BC7262SDA=HIGH)
#define	SDA_RESET()			(BC7262SDA=LOW)
#define	SDA_DIRIN()			(BC7262SDADIR=INPUT)
#define	SDA_DIROUT()		(BC7262SDADIR=OUTPUT)
#define	SDA_IN()			(BC7262SDA)
			
#define	delay_2cycle()		asm("jmp $+1")

#define	IIC_delay(varname)\
			asm("mov A,"#varname"");\
			asm("sdz acc");\
			asm("jmp $-1")

static bit	IIC_ACKBIT;
void	IIC_StartBit(void);
void	IIC_StopBit(void);
u8		IIC_DataOutput(u8 da);
u8		IIC_DataInput(u8 ack);
extern void	DelayXmSec(u8 xs);

u8	val_buf[3];
u8	RF_mode;

uc8 tx_pwr[][2] =
{
	{ 0xCD, 0xDB	},	//-10dBm
	{ 0xDD, 0xDB	},	//-5dBm
	{ 0xF7, 0xF3	},	// 0dBm
	{ 0x3B, 0xC2	},	// 5dBm
	{ 0x7D, 0xD3	},	// 7dBm
};

uc8	BC7262RegsSetupTable[][2] = 
{
	{ 0x00, 0x20	},
	{ 0x70, 0x03	},				//1.2V default 0x02 + RST_RF
	{ 0x01, 0x4A	},			
	{ 0x05, RNDDLY_WHTSEED	},
	{ 0x06, PKT_AUTORS	},
	{ 0x07, (APRD_PDTH<<6) | (RNDDLY_EN<<5) | PKT_APRD	},
	{ 0x08, PKT_PERIODS },
	{ 0x09, PKT_PERIODS>>8	},
	{ 0x0C, 0x34 | (TPCAC_EN<<6)	},	//default 0x34
//	{ 0x0F, 0x00	},				//default 0x00
//	{ 0x10, 0x00	},				//default 0x00
	{ 0x11, 0x70 | (WOT_TU<<2)	},	//time out off, always on light sleep mode
	{ 0x14, 0x5B	},
	{ 0x18, 0x16 | AGC_EN	},	
	{ 0x19, 0x14	},		//RD
//	{ 0x19, 0x10	},		//Yaoyu
	{ 0x1B, 0x4E | ACFO_EN	},
	{ 0x1E, 0x88	},				//RSSI offset
//	{ 0x1D, 0x80	}				//default 0x80
//	{ 0x20, 0x55	},				//default 0x55
//	{ 0x21, 0x55	},				//default 0x55
	{ 0x22, 0x20	},				
	{ 0x23, 0x02	},				//Kent 3(2020/11/26 & 2020/12/30), Kidd 7(2020/12/1~2020/12/22, Kidd conform follow Kent)
	{ 0x24, 0x00	},				
	{ 0x25, 0xF4	},	
	{ 0x27, 0x7C	},				
	{ 0x28, 0xC7	},				
	{ 0x29, 0xB0	},				
	{ 0x2A, 0x18	},
	{ 0x2B, 0x4C	},
//	{ 0x2C, 0x12	},				//default 0x12
//	{ 0x30, 0x12	},				//default 0x12
//	{ 0x31, },				//7dBm
//	{ 0x32, },				//7dBm
	{ 0x33, XTAL_CLOAD<<2},
//	{ 0x34, 0x5C	},				//default 0x5C
//	{ 0x35, 0x1B	},				//defaulr 0x1A b7=LIRCAL_EN, b0=LIRC_EN
	{ 0x37, 0x08	},
	{ 0x3D, 0x02	},				//L2RXTO_EN
	{ 0x3E, 0x03	},				//Layer 2 Continuous RX timeout period. Period = 250us * (1 + L2RXTO_PRD)
	{ 0x3F, (PMLEN<<5) | (WHT_EN<<4)	},	//Preamble length: 0h: 1 byte, 1h: 2 bytes
	{ 0x54,WHT_ADDR_TYPE	},
	{ 0x55, 0x61	},				
	{ 0x60, 0x00	},				//default 0x00
//	{ 0x61, (GIO2_S<<4)+GIO1_S	},
//	{ 0x61, (TXD_OUTPUT<<4)+IRQ_L2ACT	},
//	{ 0x61, (IRQ_L2ACT<<4)	},
	{ 0x61, (GIO2_S & 0x07)<< 4 | ((GIO1_S & 0x07) )},
	{ 0x62, (SDAPU<<6) | (SCLPU<<5) | GIOPU	},
	{ 0x68, (IRQACT<<7) | (IRQCLR<<6) | (CRWFF_EN<<5) | (I2COD_EN<<1) | I2CAG_EN	},
//	{ 0x72, 0x00	},				//1.2V default 0x00, b0=VCOVAL_EN
//	{ 0x7B, 0x00	},				//1.2V default 0x00
//	{ 0x71, 0x00	},				//1.2V default 0x08 (TX Free)

};

//----------------------------------------------------------------------------
//	 MCU & BC7262 interface Configure
//----------------------------------------------------------------------------
void BC7262_InterfaceConfigure(void)
{   
	_csel = 0;
    _cos  = 1;   //Seting IO
    _clop = 0;
    _csen  = 0;
    _rxctl = 0;
    _simen = 0;
    _sim0  = 1;
    _sim1  = 1;
    _sim2  = 1;
 
	BC7262SCLDIR = OUTPUT;
	BC7262SDADIR = OUTPUT;
	BC7262STSDIR = INPUT;
	BC7262STSPU = PULLUP; 
/*	BC7262STSWU = HIGH;*/
	IIC_StopBit();
}

//----------------------------------------------------------------------------
//	 BC7262 parameter initial
//----------------------------------------------------------------------------
void BC7262_ParameterInitial(void)
{
	u8	x;
	
	for(x=0;x<(sizeof(BC7262RegsSetupTable)/2);x++)
	{
		BC7262_WriteRegister(BC7262RegsSetupTable[x][0],BC7262RegsSetupTable[x][1]);	
	}
}

//----------------------------------------------------------------------------
// @brief 	: wake up BC7262																	*
// @param	:
// @retval  :
//----------------------------------------------------------------------------
void BC7262_WakeUp(void)
{
	SCL_DIROUT();
	SCL_RESET();				// SCL = low
	DelayXmSec(2*4);	
	SCL_SET();					// SCL = high	
}

//----------------------------------------------------------------------------
//	Configuration BC7262 register
//----------------------------------------------------------------------------
void BC7262_inital()
{
 	BC7262_InterfaceConfigure();
	DelayXmSec(50*4);		//50ms	
	BC7262_WakeUp();
	BC7262_ReadMultiRegister(CHIPID_REG,val_buf,3);	
	BC7262_ParameterInitial();
	BC7262_TxPower(P07DBM);
	BC7262_VCOCal();
	RF_mode = RX_MODE;	
}	

//----------------------------------------------------------------------------
//	Time out to deep sleep
//----------------------------------------------------------------------------
void BC7262_DeepSleep(void)
{
	lirc_ctl_t	regv;
	u8	x;
    
    BC7262_WakeUp();
	BC7262_WriteRegister(0x61, (INPUT_MODE & 0x07)<< 4 | ((INPUT_MODE & 0x07) ));
    BC7262_ReadRegister(LIRC_LSTO_REG, &regv.value);
	regv.bits.lstom = 0;
	BC7262_WriteRegister(LIRC_LSTO_REG, regv.value);
	RF_mode = DEEP_SLEEP;
}

//----------------------------------------------------------------------------
//	
//----------------------------------------------------------------------------
void BC7262_LightSleep(void)
{
	lirc_ctl_t	regv;
	
	if(RF_mode == DEEP_SLEEP)
	{
		BC7262_WakeUp();
		BC7262_ReadRegister(LIRC_LSTO_REG, &regv.value);
		regv.bits.lstom = 3;
		BC7262_WriteRegister(LIRC_LSTO_REG, regv.value);
		RF_mode = LIGHT_SLEEP;		
	}
}

//----------------------------------------------------------------------------
//	 BC7262 calibration
//----------------------------------------------------------------------------
void BC7262_Calibration(u8 reg, u8 val)
{
	u8	val_buf;
	
	BC7262_ReadRegister(reg, &val_buf);
	BC7262_WriteRegister(reg, val_buf+val);	
	do
	{
		BC7262_ReadRegister(reg, &val_buf);
	}while(val_buf & val);
}

//----------------------------------------------------------------------------
u8 BC7262_mode(void)
{
	return RF_mode;
}

//----------------------------------------------------------------------------
void BC7262_TxPower(u8 txp)
{
	BC7262_WriteRegister(0x31, tx_pwr[txp][0]);	
	BC7262_WriteRegister(0x32, tx_pwr[txp][1]);	
}

//----------------------------------------------------------------------------
irq_t BC7262_ClrIrq(void)
{
	irq_t	regv;
	
	BC7262_WakeUp();
	BC7262_ReadRegister(L2_IRQ_REG, &regv.value);	
	BC7262_WriteRegister(L2_IRQ_REG, regv.value);
	
	return regv;		
}

//----------------------------------------------------------------------------
// @brief 	: write PDUFIFO	
// @param	:
// @retval  :
//----------------------------------------------------------------------------
void BC7262_WritePDUFIFO(u8 *pdu,u8 len)
{	
	BC7262_WriteRegister(PDU_PTR_REG,_FLUSH_FIFO_);		//reset FIFO pointer	
	BC7262_WriteMultiRegister(PDU_DATA_REG,pdu,len);
}

//----------------------------------------------------------------------------
// @brief 	: read PDUFIFO	
// @param	:
// @retval  :
//----------------------------------------------------------------------------
void BC7262_ReadPDUFIFO(adv_pdu_struct *adv,u8 fifo,u8 pdud)
{
	pkt_ctl_t	regv;
	u8	rx_dta, rx_len;
	
	BC7262_ReadRegister(PKT_CTL_REG, &regv.value);
	regv.bits.fifo_sel = fifo;
	regv.bits.pdud_rs = pdud;	
	BC7262_WriteRegister(PKT_CTL_REG, regv.value);

	BC7262_ReadRegister(PLH1_CTL_REG+2*fifo, &rx_dta);
	BC7262_ReadRegister(PLH1_LEN_REG+2*fifo, &rx_len);
	adv->header.value = (rx_len << 8) + rx_dta;
	BC7262_ReadMultiRegister(DEV_ADDR_0_REG, adv->adv_addr, 6);
	if(rx_len > 6)
	BC7262_ReadMultiRegister(PDU_DATA_REG, adv->adv_data, rx_len-6);
}

//----------------------------------------------------------------------------
// @brief 	: write PDU header																	*
// @param	:
// @retval  :
//----------------------------------------------------------------------------
void BC7262_WriteHeader(u8 reg, u8 *hdr)
{
	BC7262_WriteMultiRegister(PLH1_CTL_REG+(reg*2), hdr, 2);
}

//----------------------------------------------------------------------------
// @brief 	: write Access Address																	*
// @param	:
// @retval  :
//----------------------------------------------------------------------------
void BC7262_WriteAccAddr(u8 *addr)
{
	BC7262_WriteMultiRegister(ACC_ADDR_0_REG, addr, 4);
}

//----------------------------------------------------------------------------
//	 BC7262 read register
//----------------------------------------------------------------------------
u8 BC7262_ReadRegister(u8 adr,u8 *rval)
{
	u8	ack;
	
	IIC_StartBit();
//	ack=IIC_DataOutput(IIC_WRITE_DADDR);	
	IIC_DataOutput(IIC_WRITE_DADDR);
	asm volatile("mov %0,A"::"m"(ack));
	if(ack)
	{
//		IIC_DataOutput(adr);				/* write register address */
		asm volatile("mov A,%0"::"m"(adr));	
		asm volatile("call _IIC_DataOutput");			
		IIC_StopBit();						
		IIC_StartBit();					/* restart bit */
		IIC_DataOutput(IIC_READ_DADDR);
		asm volatile("mov %0,A"::"m"(ack));
		if(ack) *rval=IIC_DataInput(FALSE);
	}
	IIC_StopBit();
	return(ack);
}

//----------------------------------------------------------------------------
//	 BC7262 read multibyte register 
//----------------------------------------------------------------------------
u8 BC7262_ReadMultiRegister(u8 adr,u8 *rval,u8 leng)
{
	u8	ack;
	
	IIC_StartBit();
//	ack=IIC_DataOutput(IIC_WRITE_DADDR);
	IIC_DataOutput(IIC_WRITE_DADDR);
	asm volatile("mov %0,A"::"m"(ack));	
//	if(ack)
	if(_acc)
	{
//		IIC_DataOutput(adr);				/* write register address */		
		asm volatile("mov A,%0"::"m"(adr));	
		asm volatile("call _IIC_DataOutput");	
		IIC_StopBit();						
		IIC_StartBit();					/* restart bit */
//		ack=IIC_DataOutput(IIC_READ_DADDR);
		IIC_DataOutput(IIC_READ_DADDR);
		asm volatile("mov %0,A"::"m"(ack));
//		if(ack)
		if(_acc)
		{
			_mp1 = ((u16)rval & 0xFF);
			_bp = ((u16)rval >> 8);			
			while(leng)
			{	
//				*rval=IIC_DataInput((leng > 1)?TRUE:FALSE);
				asm volatile("deca %0"::"m"(leng));	/* if(leng==1) acc=FALSE else acc=TRUE */
				asm volatile("call _IIC_DataInput");
				asm volatile("mov %0,A"::"m"(_iar1));
//				*rval=adr;
//				rval++;
				_mp1++;
				leng--;
			}
		}
	}
	IIC_StopBit();
	return(ack);	
}

//----------------------------------------------------------------------------
//	 BC7262 write register 
//----------------------------------------------------------------------------
u8 BC7262_WriteRegister(u8 adr,u8 val)
{
	u8	ack;
	
	IIC_StartBit();	
//	ack = IIC_DataOutput(IIC_WRITE_DADDR);
	IIC_DataOutput(IIC_WRITE_DADDR);
	asm volatile("mov %0,A"::"m"(ack));
	if(ack)
	{		
		/* write register address */		
//		IIC_DataOutput(adr);				
		asm volatile("mov A,%0"::"m"(adr));	
		asm volatile("call _IIC_DataOutput");
		asm volatile("mov %0,A"::"m"(ack));
		if(ack)
		{
			/* write data to register */
//			ack=IIC_DataOutput(val);
			asm volatile("mov A,%0"::"m"(val));	
			asm volatile("call _IIC_DataOutput");
			asm volatile("mov %0,A"::"m"(ack));
		}
	}
	IIC_StopBit();
	return(ack);
}

//----------------------------------------------------------------------------
//	 BC7262 write multibyte register
//----------------------------------------------------------------------------
u8 BC7262_WriteMultiRegister(u8 adr,u8 *val,u8 leng)
{
	u8	ack;
	
	IIC_StartBit();
//	ack = IIC_DataOutput(IIC_WRITE_DADDR);
	IIC_DataOutput(IIC_WRITE_DADDR);
	asm volatile("mov %0,A"::"m"(ack));	
	if(_acc)
	{
//		ack = IIC_DataOutput(adr);				/* write register address */
		asm volatile("mov A,%0"::"m"(adr));	
		asm volatile("call _IIC_DataOutput");
		asm volatile("mov %0,A"::"m"(ack));
		_mp1 = ((u16)val & 0xFF);
		_bp = ((u16)val >> 8);						
		while((ack==TRUE) && (leng > 0))
		{
//			ack=IIC_DataOutput(*val);
			asm volatile("mov A,%0"::"m"(_iar1));	
			asm volatile("call _IIC_DataOutput");
			asm volatile("mov %0,A"::"m"(ack));
			_mp1++;
			leng--;
		}
	}
	IIC_StopBit();
	return(ack);
}

//----------------------------------------------------------------------------
//	 IIC start bit 
//----------------------------------------------------------------------------
void IIC_StartBit(void)
{
	SCL_DIROUT();
	SCL_SET();
	delay_2cycle();	
	SDA_DIROUT();
	SDA_RESET();
	IIC_delay(2);
	SCL_RESET();
}

//----------------------------------------------------------------------------
//	 IIC stop bit
//----------------------------------------------------------------------------
void IIC_StopBit(void)
{
	SCL_DIROUT();
	SCL_RESET();
	SDA_DIROUT();
	SDA_RESET();
	IIC_delay(2);
	SCL_SET();	
	IIC_delay(2);
	SDA_SET();
}

//----------------------------------------------------------------------------
//	 IIC data output
//----------------------------------------------------------------------------
u8 IIC_DataOutput(u8 da)
{
	SDA_RESET();	
	SDA_DIROUT();	
	asm volatile("mov A,8");
	while(_acc)
	{
		delay_2cycle();
		/* SCL=LOW */
		SCL_RESET();
		delay_2cycle();
		/* data out,if(da & 0x80) SDA=HIGH else SDA=LOW */
		asm volatile("snz %0.7"::"m"(da));
		SDA_RESET(); 
		asm volatile("sz %0.7"::"m"(da));		
		SDA_SET();
		delay_2cycle();
		GCC_NOP();
		/* SCL=HIGH */
		SCL_SET();
		/* data lift shift */
		GCC_RL(da);
		asm volatile("dec	acc");
		GCC_NOP();
	}
	GCC_NOP();
	/* SCL=LOW */
	SCL_RESET();
	/* SDA TO INPUT MODE */
	SDA_DIRIN();
	SDA_SET();
	GCC_NOP();
	IIC_delay(2);
	/* SCL=HIGH */
	SCL_SET();
	GCC_NOP();
	delay_2cycle();
	/* check ack bit */
	IIC_ACKBIT=FALSE;
	if(!SDA_IN()) IIC_ACKBIT=TRUE;
	delay_2cycle();
	/* SCL=LOW */
	SCL_RESET();
	delay_2cycle();
	return(IIC_ACKBIT);
}

//----------------------------------------------------------------------------
//	 IIC data input
//----------------------------------------------------------------------------
u8 IIC_DataInput(u8 ack)
{	
	if(ack) IIC_ACKBIT=TRUE; else IIC_ACKBIT=FALSE;	
	SDA_DIRIN();
	ack=0;
	asm volatile("mov A,8");
	while(_acc)
	{
		/* SCL = LOW */
		SCL_RESET();		
		/* data lift shift bit */
		GCC_RL(ack);
		delay_2cycle();
		delay_2cycle();
		delay_2cycle();
		delay_2cycle();
		/* SCL = HIGH */
		SCL_SET();
		GCC_NOP();		
		/* data in */
		if(SDA_IN()) asm volatile("set %0.0"::"m"(ack));
		asm volatile("dec	acc");		
	}
	/* SCL = LOW */
	SCL_RESET();
	GCC_NOP();	
	/* output ack bit */
	if(IIC_ACKBIT) SDA_RESET(); else SDA_SET();
	/* SCL = HIGH */
	/* SDA to OUTPUT MODE */
	SDA_DIROUT();	
	delay_2cycle();	
	SCL_SET();
	IIC_delay(3);
	SCL_RESET();
	delay_2cycle();
	return(ack);
}